/*******************************************************************/
/*                                                                 */
/*                      ADOBE CONFIDENTIAL                         */
/*                   _ _ _ _ _ _ _ _ _ _ _ _ _                     */
/*                                                                 */
/* Copyright 1997 - 1999 Adobe Systems Incorporated                */
/* All Rights Reserved.                                            */
/*                                                                 */
/* NOTICE:  All information contained herein is, and remains the   */
/* property of Adobe Systems Incorporated and its suppliers, if    */
/* any.  The intellectual and technical concepts contained         */
/* herein are proprietary to Adobe Systems Incorporated and its    */
/* suppliers and may be covered by U.S. and Foreign Patents,       */
/* patents in process, and are protected by trade secret or        */
/* copyright law.  Dissemination of this information or            */
/* reproduction of this material is strictly forbidden unless      */
/* prior written permission is obtained from Adobe Systems         */
/* Incorporated.                                                   */
/*                                                                 */
/*******************************************************************/
//-------------------------------------------------------------------
//-------------------------------------------------------------------------------
//
//	File:
//		PIUUIParams.cpp
//
//
//	Description:
//		This library contains the source and
//		routines to simplify the use of suites and also some
//		helpful common plug-in functions. 
//
//	Use:
//		PIUBasic is intended to group common functions
//		into higher-level macros and routines to simplify
//		plug-in programming.
//
//		Most expect on Windows, for hDllInstance to
//		be a global handle reference to your plug-in DLL.
//
//	Version history:
//		Version 1.0.0	7/31/1997	Created for Photoshop 5.0
//			Written by Andrew Coven.
//
//-------------------------------------------------------------------------------

#include "PIUUIParams.h"

//-------------------------------------------------------------------------------
//	User interface parameters.
//-------------------------------------------------------------------------------
PIUUIParams_t::
	PIUUIParams_t
		(
		SPPluginRef plugInRef = NULL
		) :
		plugInRef_(plugInRef),
		hDLLInstance_(NULL)
	{
	// Intentionally left blank.
	}

PIUUIParams_t::PIUUIParams_t() :
	plugInRef_(NULL)
	{
	// Intentionally left blank.
	}
	
PIUUIParams_t::
	PIUUIParams_t
	(
	const PIUUIParams_t & source
	) :
	plugInRef_(source.plugInRef_),
	hDLLInstance_(source.hDLLInstance_)
	{
	// Intentionally left blank.
	}

PIUUIParams_t & PIUUIParams_t::operator=
	(
	const PIUUIParams_t & source
	)
	{
	plugInRef_ = source.plugInRef_;
	hDLLInstance_ = source.hDLLInstance_;
	return *this;
	}

bool PIUUIParams_t::ParamsValid()
	{
	return (plugInRef_ != NULL);
	}

void PIUUIParams_t::SetPlugInRef
	(
	SPPluginRef plugInRef
	)
	{
	plugInRef_ = plugInRef;
	}
	
SPPluginRef PIUUIParams_t::GetPlugInRef(void) const
	{
	return plugInRef_;
	}


void PIUUIParams_t::SetDLLInstance
	(
	void* hDLLInstance
	)
	{
	hDLLInstance_ = hDLLInstance;
	}
	
void* PIUUIParams_t::GetDLLInstance(void) const
	{
	return hDLLInstance_;
	}

//-------------------------------------------------------------------------------

// end PIUUIParams.cpp
